class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Daily Mirror Football'
    oldest_article = 7
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    keep_only_tags = [dict(name='div', attrs={'class':'maincolcentre'})]    
    remove_tags_before = dict(id='')
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['appended_html','recommend_links','mnb_text']}),
                   dict(name='div', attrs={'id':['','',]}),
                   dict(name='ul', attrs={'class':['ali_icons']}),
	 dict(name='p', attrs={'class':'mn_header_details'}),
                   dict(name='img'),]

    feeds          = [(u'Football', u'http://www.mirrorfootball.co.uk/rss.xml'), 
                         (u'Football News', u'http://www.mirrorfootball.co.uk/news/rss.xml'), 
                         (u'Football Opinion', u'http://www.mirrorfootball.co.uk/opinion/rss.xml')] 
                       
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
